import { Request, Response } from 'express';
import { sellersService } from './service';

export const sellersController = {
  // POST /api/sellers
  async createSeller(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { data, error } = await sellersService.createSeller(user.id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // GET /api/sellers
  async listSellers(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { market_id, status } = req.query;
    const filters: any = {};
    if (market_id) filters.market_id = market_id;
    if (status) filters.status = status;

    const { data, error } = await sellersService.listSellers(user.id, filters);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // GET /api/sellers/:id
  async getSeller(req: any, res: Response) {
    const { id } = req.params;
    const { data, error } = await sellersService.getSeller(id);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // PUT /api/sellers/:id
  async updateSeller(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.updateSeller(id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // DELETE /api/sellers/:id
  async deleteSeller(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.deleteSeller(id);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // POST /api/sellers/:id/inventory
  async addInventory(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.addInventory(id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // GET /api/sellers/:id/inventory
  async getInventory(req: any, res: Response) {
    const { id } = req.params;
    const { data, error } = await sellersService.getInventory(id);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // PUT /api/sellers/:id/inventory/:item_id
  async updateInventory(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { item_id } = req.params;
    const { data, error } = await sellersService.updateInventory(item_id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // DELETE /api/sellers/:id/inventory/:item_id
  async deleteInventory(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { item_id } = req.params;
    const { data, error } = await sellersService.deleteInventory(item_id);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // POST /api/sellers/:id/assign-order
  async assignOrder(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.assignOrder(id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // PUT /api/sellers/:id/mark-fulfilled
  async markFulfilled(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.markFulfilled(id, req.body);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  },

  // GET /api/sellers/:id/analytics
  async getAnalytics(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });

    const { id } = req.params;
    const { data, error } = await sellersService.getSellerAnalytics(id);
    if (error) return res.status(400).json({ error });
    return res.json({ success: true, data });
  }
}; 